package nemosofts.notes.app.activity;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.Html;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import androidx.activity.EdgeToEdge;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.Toolbar;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.nemosofts.AppCompatActivity;
import androidx.nemosofts.material.ImageViewRound;

import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

import nemosofts.notes.app.R;
import nemosofts.notes.app.callback.Callback;
import nemosofts.notes.app.dialog.DialogUtil;
import nemosofts.notes.app.item.Note;
import nemosofts.notes.app.utils.AsyncTaskExecutor;
import nemosofts.notes.app.utils.IfSupported;
import nemosofts.notes.app.utils.ReminderScheduler;
import nemosofts.notes.app.utils.helper.DBHelper;
import nemosofts.notes.app.utils.helper.Helper;
import nemosofts.notes.app.widget.NoteWidgetProvider;

public class RestoreNoteActivity extends AppCompatActivity {

    private TextView inpuNoteTitle;
    private TextView inpuNoteSubtitle;
    private TextView inpuNoteText;
    private TextView textDeteTime;
    private TextView textWebURL;
    private ImageViewRound imageNote;
    private String setectedNoteColor;
    private View viewSubtitleIndicator;
    private LinearLayout layoutWebURL;
    private String  setectedImagePath;
    private static final int REQUST_CODE_STORAGE_PERMISSION = 1;
    private Note alreadyAvailableNote;
    private DBHelper dbHelper;
    private final ActivityResultLauncher<String> imagePickerLauncher =
            registerForActivityResult(new ActivityResultContracts.GetContent(), this::handleImagePicked);

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        IfSupported.isRTL(this);
        IfSupported.isScreenshot(this);
        EdgeToEdge.enable(this);
        ViewCompat.setOnApplyWindowInsetsListener(findViewById(R.id.bg_page), (v, insets) -> {
            Insets systemBars = insets.getInsets(WindowInsetsCompat.Type.systemBars());
            v.setPadding(systemBars.left, systemBars.top, systemBars.right, systemBars.bottom);
            return insets;
        });

        Toolbar toolbar = findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
        if (getSupportActionBar() != null) {
            getSupportActionBar().setDisplayHomeAsUpEnabled(true);
            getSupportActionBar().setDisplayShowHomeEnabled(true);
        }
        toolbar.setNavigationOnClickListener(view -> onBackPressed());
        setTitle(R.string.app_name);

        dbHelper = new DBHelper(this);

        inpuNoteTitle = findViewById(R.id.reatore_inputNoteTitle);
        inpuNoteSubtitle = findViewById(R.id.reatore_inputNoteSubtitle);
        inpuNoteText = findViewById(R.id.reatore_inputNote);
        textDeteTime = findViewById(R.id.reatore_textDeteTime);
        viewSubtitleIndicator = findViewById(R.id.reatore_viewSubtitleIndicator);
        imageNote = findViewById(R.id.reatore_imageNote);
        textWebURL = findViewById(R.id.reatore_textWebURL);
        layoutWebURL = findViewById(R.id.reatore_layoutWebURL);

        textDeteTime.setText(
                new SimpleDateFormat("EEEE , dd MMMM yyyy HH:mm a", Locale.getDefault())
                .format(new Date())
        );

        setectedNoteColor = "#333333";
        setectedImagePath = "";

        if (getIntent().getBooleanExtra("isViewOrUpdate",false)){
            alreadyAvailableNote = (Note) getIntent().getSerializableExtra("note");
            setViewOrUpdateNote();
        }

        setSubtitleIndicatorColor();

        LinearLayout adView = findViewById(R.id.ll_adView);
        new Helper(this).showBannerAd(adView);
    }

    @Override
    public int setContentViewID() {
        return R.layout.activity_reatore_note;
    }

    private void setViewOrUpdateNote() {
        inpuNoteTitle.setText(alreadyAvailableNote.getTitle());
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            inpuNoteText.setText(Html.fromHtml(alreadyAvailableNote.getNoteText(), Html.FROM_HTML_MODE_COMPACT));
        } else {
            inpuNoteText.setText(Html.fromHtml(alreadyAvailableNote.getNoteText()));
        }

        inpuNoteSubtitle.setText(alreadyAvailableNote.getSubtitle());
        textDeteTime.setText(alreadyAvailableNote.getDateTime());
        setectedNoteColor = alreadyAvailableNote.getColor();

        if (alreadyAvailableNote.getImagePath() != null && !alreadyAvailableNote.getImagePath().trim().isEmpty()){
            imageNote.setImageBitmap(BitmapFactory.decodeFile(alreadyAvailableNote.getImagePath()));
            imageNote.setVisibility(View.VISIBLE);
            findViewById(R.id.reatore_imageRemoveImage).setVisibility(View.VISIBLE);
            setectedImagePath = alreadyAvailableNote.getImagePath();
        }

        if (alreadyAvailableNote.getWebLink() != null && !alreadyAvailableNote.getWebLink().trim().isEmpty()){
            textWebURL.setText(alreadyAvailableNote.getWebLink());
            layoutWebURL.setVisibility(View.VISIBLE);
        }
    }

    private void saveNote() {

        final Note note = new  Note();
        note.setTitle(alreadyAvailableNote.getTitle());
        note.setSubtitle(alreadyAvailableNote.getSubtitle());
        note.setNoteText(alreadyAvailableNote.getNoteText());
        note.setDateTime(alreadyAvailableNote.getDateTime());
        note.setColor(setectedNoteColor);
        note.setImagePath(setectedImagePath);
        note.setCatId(alreadyAvailableNote.getCatId());
        note.setReminderTime(alreadyAvailableNote.getReminderTime());
        note.setReminderEnabled(alreadyAvailableNote.isReminderEnabled());

        if (layoutWebURL.getVisibility() == View.VISIBLE){
            note.setWebLink(textWebURL.getText().toString());
        }

        new AsyncTaskExecutor<Void, Void, Long>() {

            @Override
            protected Long doInBackground(Void unused) {
                try {
                    long id = dbHelper.saveNote(note);
                    dbHelper.deleteDeletedNote(alreadyAvailableNote.getId());
                    return id;
                } catch (Exception e) {
                    return -1L;
                }
            }

            @SuppressLint("NotifyDataSetChanged")
            @Override
            protected void onPostExecute(Long id) {
                if (isFinishing()){
                    return;
                }
                if (id != null && id > 0) {
                    if (note.isReminderEnabled() && note.getReminderTime() > 0) {
                        ReminderScheduler.scheduleReminder(RestoreNoteActivity.this, note);
                    } else {
                        ReminderScheduler.cancelReminder(RestoreNoteActivity.this, note.getId());
                    }
                    NoteWidgetProvider.requestUpdate(RestoreNoteActivity.this);
                }
                Callback.setRecreate(true);
                Intent intent = new Intent();
                intent.putExtra("isNoteDeleted",true);
                setResult(RESULT_OK, intent);
                finish();
            }
        }.execute();
    }

    private void setSubtitleIndicatorColor(){
        GradientDrawable gradientDrawable = (GradientDrawable) viewSubtitleIndicator.getBackground();
        gradientDrawable.setColor(Color.parseColor(setectedNoteColor));
    }

    private void selectImage() {
        imagePickerLauncher.launch("image/*");
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == REQUST_CODE_STORAGE_PERMISSION && grantResults.length > 0){
            if (grantResults[0] == PackageManager.PERMISSION_GRANTED){
                selectImage();
            }else {
                Toast.makeText(this,"Permissions Denied!",Toast.LENGTH_SHORT).show();
            }
        }
    }

    private void handleImagePicked(@Nullable Uri selectedImageUri) {
        if (selectedImageUri == null){
            return;
        }
        try {
            InputStream inputStream = getContentResolver().openInputStream(selectedImageUri);
            Bitmap bitmap = BitmapFactory.decodeStream(inputStream);
            imageNote.setImageBitmap(bitmap);
            imageNote.setVisibility(View.VISIBLE);
            findViewById(R.id.reatore_imageRemoveImage).setVisibility(View.VISIBLE);

            setectedImagePath = getPathFromUri(selectedImageUri);

        } catch (Exception e) {
            Toast.makeText(this, e.getMessage(), Toast.LENGTH_SHORT).show();
        }
    }

    private String getPathFromUri(Uri contenUri) {
        String filePath;
        Cursor cursor = getContentResolver().query(contenUri, null, null, null, null);
        if (cursor == null){
            filePath = contenUri.getPath();
        } else {
            cursor.moveToFirst();
            int index = cursor.getColumnIndex("_data");
            filePath =cursor.getString(index);
            cursor.close();
        }
        return  filePath;
    }


    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        getMenuInflater().inflate(R.menu.menu_restore, menu);
        return true;
    }

    @SuppressLint("NonConstantResourceId")
    @Override
    public boolean onOptionsItemSelected(final MenuItem item) {
        int id = item.getItemId();
        if (id == R.id.nav_restore) {
            saveNote();
        } else if (id == R.id.nav_delete) {
            showDeletNoteDialog();
        }
        return super.onOptionsItemSelected(item);
    }

    private void showDeletNoteDialog() {
        DialogUtil.trashDialog(this, new DialogUtil.DeleteListener() {
            @Override
            public void onDelete() {
                new AsyncTaskExecutor<String, String, String>() {

                    @Override
                    protected String doInBackground(String strings) {
                        try {
                            dbHelper.deleteDeletedNote(alreadyAvailableNote.getId());
                            return "1";
                        } catch (Exception e) {
                            return "0";
                        }
                    }

                    @SuppressLint("NotifyDataSetChanged")
                    @Override
                    protected void onPostExecute(String s) {
                        if (isFinishing()){
                            return;
                        }
                        Intent intent = new Intent();
                        intent.putExtra("isNoteDeleted",true);
                        setResult(RESULT_OK, intent);
                        finish();
                    }
                }.execute();
            }

            @Override
            public void onCancel() {
                // method is empty
            }
        });
    }
}